///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK AddSQLOptionsDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    static HWND SQLServer_hWnd = NULL;
    static HWND DataBase_hWnd  = NULL;
    static HWND DBDriver_hWnd  = NULL;
    static HWND UserName_hWnd  = NULL;
    static HWND Password_hWnd  = NULL;


	if(xMessage == WM_INITDIALOG) // Received A Initilize Dialog Message
	{
		AddSQLOptionsDialog_hWnd = xHandle;

		SendMessage(AddSQLOptionsDialog_hWnd,(UINT)WM_SETTEXT,(WPARAM)0,(LPARAM)"SQL Options");
		SendMessage(AddSQLOptionsDialog_hWnd,WM_SETICON,TRUE,(LPARAM)LoadIcon(MainInstance,MAKEINTRESOURCE(DialogIcon)));

        SQLServer_hWnd = GetDlgItem(AddSQLOptionsDialog_hWnd, 1000);
        DataBase_hWnd  = GetDlgItem(AddSQLOptionsDialog_hWnd, 1001);
        DBDriver_hWnd  = GetDlgItem(AddSQLOptionsDialog_hWnd, 1002);
        UserName_hWnd  = GetDlgItem(AddSQLOptionsDialog_hWnd, 2000);
        Password_hWnd  = GetDlgItem(AddSQLOptionsDialog_hWnd, 2001);

        Set_Text(SQLServer_hWnd, BackupServer);
        Set_Text(DataBase_hWnd,  BackupDataBase);
        Set_Text(DBDriver_hWnd,  BackupDriver);
        Set_Text(UserName_hWnd,  BackupUserID);
        Set_Text(Password_hWnd,  BackupUserPW);

        if(BackupTrusted)
            CheckDlgButton(AddSQLOptionsDialog_hWnd, 3000, BST_CHECKED);

 		CenterWindow(AddSQLOptionsDialog_hWnd);

		return 0;
	}


	if(xMessage == WM_COMMAND) // Received A Message
	{
		if(wParam == 100) //- Ok (Dialog Command)
		{
            char *xSQLServer = Get_Text(SQLServer_hWnd);
            char *xDataBase  = Get_Text(DataBase_hWnd);
            char *xDBDriver  = Get_Text(DBDriver_hWnd);
            char *xUserName  = Get_Text(UserName_hWnd);
            char *xPassword  = Get_Text(Password_hWnd);

            if( strlen(xSQLServer) < 1)
            {
                MessageBox(AddSQLOptionsDialog_hWnd, "You must specify a SQL server.", TitleCaption, 0);
                return 0;
            }

            if( strlen(xDataBase) < 1)
            {
                MessageBox(AddSQLOptionsDialog_hWnd, "You must specify a SQL data base.", TitleCaption, 0);
                return 0;
            }

            if( strlen(xDBDriver) < 1)
            {
                MessageBox(AddSQLOptionsDialog_hWnd, "You must specify a data base driver.", TitleCaption, 0);
                return 0;
            }

            SQLOD.SQLServer = xSQLServer;
            SQLOD.DataBase  = xDataBase;
            SQLOD.DBDriver  = xDBDriver;
            SQLOD.UserName  = xUserName;
            SQLOD.Password  = xPassword;

            CopyString(xDataBase,   BackupDataBase, strlen(xDataBase));
            CopyString(xDBDriver,   BackupDriver,   strlen(xDBDriver));
            CopyString(xSQLServer,  BackupServer,   strlen(xSQLServer));
            CopyString(xUserName,   BackupUserID,   strlen(xUserName));
            CopyString(xPassword,   BackupUserPW,   strlen(xPassword));

            if(IsDlgButtonChecked(AddSQLOptionsDialog_hWnd, 3000))
            {
                SQLOD.IsTrusted = TRUE;
                BackupTrusted = TRUE;
            }
            else{
                BackupTrusted = FALSE;
                SQLOD.IsTrusted = FALSE;
            }

            SQLOD.Complete = TRUE;

            SetValues();

			EndDialog(AddSQLOptionsDialog_hWnd,0);
			return 0;
		}

		if(wParam==101) //- Cancel (Dialog Command)
		{
			EndDialog(AddSQLOptionsDialog_hWnd,0);
			return 0;
		}

		if(wParam==102) //- Select database (Dialog Command)
		{
            JID.Dialog_hWnd = AddSQLOptionsDialog_hWnd;
            JID.Database_hWnd = DataBase_hWnd;
        	DialogBox(MainInstance, MAKEINTRESOURCE(SelectDB), AddSQLOptionsDialog_hWnd, SelectDBDialog);
            return 0;
        }

		return 0;
	}

	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

